SET QUOTED_IDENTIFIER ON
GO

IF EXISTS
  (SELECT *
     FROM [dbo].[KYScriptLog] SKL
    WHERE SKL.[MajorVersion] = 5
      AND SKL.[MinorVersion] = 1
      AND SKL.[Build] = 1
      AND SKL.[Revision] = 155
      AND SKL.[COMMENT] = '003 Indexes_For_Query_Optimising.sql')
BEGIN
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
VALUES(GetDate(),
       5,
       1,
       1,
       155,
       'Build 5.1.1.155',
       '003 Indexes_For_Query_Optimising.sql **FAILED**')
GO

IF EXISTS
  (SELECT *
     FROM SYS.[indexes] SO
    WHERE SO.[name] = 'KYNET_index_CaseMaster_On_CSCode')
BEGIN
  DROP INDEX [KYNET_index_CaseMaster_On_CSCode] ON [dbo].[CaseMaster]
END
GO
CREATE NONCLUSTERED INDEX [KYNET_index_CaseMaster_On_CSCode] ON [dbo].[CaseMaster] 
(
	[CSCODE] ASC
)
INCLUDE ( [CSWKTCODE]) WITH (SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF) ON [PRIMARY]

GO

IF EXISTS
  (SELECT *
     FROM SYS.[indexes] SO
    WHERE SO.[name] = 'KYNET_index_Contacts_On_Code')
BEGIN
  DROP INDEX [KYNET_index_Contacts_On_Code] ON [dbo].[Contacts]
END
GO
CREATE NONCLUSTERED INDEX [KYNET_index_Contacts_On_Code] ON [dbo].[Contacts] 
(
	[Code] ASC
)
INCLUDE ( [Name]) WITH (SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF) ON [PRIMARY]

GO

--MOVED to TableScripts as part of the changes to move "closed" case information back to main tables. START
--
--IF EXISTS
--  (SELECT *
--     FROM SYS.[indexes] SO
--    WHERE SO.[name] = 'KYNET_index_diary_On_CaseCode_Status_Date_DYStartTime_ActionID')
--BEGIN
--  DROP INDEX [KYNET_index_diary_On_CaseCode_Status_Date_DYStartTime_ActionID] ON [dbo].[diary]
--END
--GO
--CREATE NONCLUSTERED INDEX [KYNET_index_diary_On_CaseCode_Status_Date_DYStartTime_ActionID] ON [dbo].[diary] 
--(
--	[CASECODE] ASC,
--	[STATUS] ASC,
--	[DATE] DESC,
--	[DYSTARTTIME] DESC,
--	[ACTIONID] DESC
--)
--INCLUDE ( [ORGINALACTIONID]) WITH (SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF) ON [PRIMARY]

--GO
--
--MOVED to TableScripts as part of the changes to move "closed" case information back to main tables. END


--MOVED to TableScripts as part of the changes to move "closed" case information back to main tables. START
--
--IF EXISTS
--  (SELECT *
--     FROM SYS.[indexes] SO
--    WHERE SO.[name] = 'KYNET_index_diary_On_ActionID_CaseCode')
--BEGIN
--  DROP INDEX [KYNET_index_diary_On_ActionID_CaseCode] ON [dbo].[diary]
--END
--GO
--CREATE NONCLUSTERED INDEX [KYNET_index_diary_On_ActionID_CaseCode] ON [dbo].[diary] 
--(
--	[ACTIONID] ASC,
--	[CASECODE] ASC
--)
--INCLUDE ( [DATE],
--[STATUS],
--[ACTIONTYPE],
--[PROCESSTYPE],
--[FNCODE],
--[IMAGENO],
--[PRIORITY],
--[HIGHLIGHTED],
--[PROCESSSTATUS],
--[WORKPROCESS],
--[DELEGATIONSTATUS]) WITH (SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF) ON [PRIMARY]

--GO
--
--MOVED to TableScripts as part of the changes to move "closed" case information back to main tables. END

IF EXISTS
  (SELECT *
     FROM SYS.[indexes] SO
    WHERE SO.[name] = 'KYNET__index_DiaryAttachments_On_DiaryID')
BEGIN
  DROP INDEX [KYNET__index_DiaryAttachments_On_DiaryID] ON [dbo].[DiaryAttachments]
END
GO
CREATE NONCLUSTERED INDEX [KYNET__index_DiaryAttachments_On_DiaryID] ON [dbo].[DiaryAttachments] 
(
	[DIARYID] ASC
)WITH (SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF) ON [PRIMARY]

GO

IF EXISTS(select * 
            from sys.[objects] SO
                 INNER JOIN sys.[stats] SS
                         ON SS.[object_id] = SO.[object_id]
                        AND SS.[name] = 'KYNET__stat_DiaryDelegations_On_DelType_ActionId_Date'
           where SO.[name] = 'DiaryDelegations'
             AND SO.[type] = 'U')
BEGIN
  drop statistics [dbo].[DiaryDelegations].[KYNET__stat_DiaryDelegations_On_DelType_ActionId_Date]
END
GO

CREATE STATISTICS [KYNET__stat_DiaryDelegations_On_DelType_ActionId_Date] ON [dbo].[DiaryDelegations]([DelType], [ACTIONID], [DATE])

GO

IF EXISTS(select * 
            from sys.[objects] SO
                 INNER JOIN sys.[stats] SS
                         ON SS.[object_id] = SO.[object_id]
                        AND SS.[name] = 'KYNET__stat_DiaryDelegations_On_Date_ActionID_Status'
           where SO.[name] = 'DiaryDelegations'
             AND SO.[type] = 'U')
BEGIN
  drop statistics [dbo].[DiaryDelegations].[KYNET__stat_DiaryDelegations_On_Date_ActionID_Status]
END
GO

CREATE STATISTICS [KYNET__stat_DiaryDelegations_On_Date_ActionID_Status] ON [dbo].[DiaryDelegations]([DATE], [ACTIONID], [STATUS])
  
GO

IF EXISTS(select * 
            from sys.[objects] SO
                 INNER JOIN sys.[stats] SS
                         ON SS.[object_id] = SO.[object_id]
                        AND SS.[name] = 'KYNET_stat_DiaryDelegations_MultiColumns'
           where SO.[name] = 'DiaryDelegations'
             AND SO.[type] = 'U')
BEGIN
  drop statistics [dbo].[DiaryDelegations].[KYNET_stat_DiaryDelegations_MultiColumns]
END
GO

CREATE STATISTICS [KYNET_stat_DiaryDelegations_MultiColumns] ON [dbo].[DiaryDelegations]([STATUS], [DATE], [DelType], [ACTIONID], [HANDLER], [TIME], [AssignNo])

GO

IF EXISTS
  (SELECT *
     FROM SYS.[indexes] SO
    WHERE SO.[name] = 'KYNET__index_DiaryDelegations_On_MultiColumns')
BEGIN
  DROP INDEX [KYNET__index_DiaryDelegations_On_MultiColumns] ON [dbo].[DiaryDelegations]
END
GO
CREATE NONCLUSTERED INDEX [KYNET__index_DiaryDelegations_On_MultiColumns] ON [dbo].[DiaryDelegations] 
(
	[HANDLER] DESC,
	[DATE] DESC,
	[TIME] DESC,
	[AssignNo] DESC,
	[STATUS] ASC
)
INCLUDE ( [ACTIONID],
[TEAM],
[OWNER],
[DELEGATESTATUS],
[FromHandler],
[DelType]) WITH (SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF) ON [PRIMARY]

GO

IF EXISTS(select * 
            from sys.[objects] SO
                 INNER JOIN sys.[stats] SS
                         ON SS.[object_id] = SO.[object_id]
                        AND SS.[name] = 'KYNET_stat_DiaryDelegations_On_ACTIONID_STATUS'
           where SO.[name] = 'DiaryDelegations'
             AND SO.[type] = 'U')
BEGIN
  drop statistics [dbo].[DiaryDelegations].[KYNET_stat_DiaryDelegations_On_ACTIONID_STATUS]
END
GO

CREATE STATISTICS [KYNET_stat_DiaryDelegations_On_ACTIONID_STATUS] ON [dbo].[DiaryDelegations]([ACTIONID], [STATUS])

GO

IF EXISTS(select * 
            from sys.[objects] SO
                 INNER JOIN sys.[stats] SS
                         ON SS.[object_id] = SO.[object_id]
                        AND SS.[name] = 'KYNET_stat_Matters_On_Permissions_Code'
           where SO.[name] = 'matters'
             AND SO.[type] = 'U')
BEGIN
  drop statistics [dbo].[matters].[KYNET_stat_Matters_On_Permissions_Code]
END
GO

CREATE STATISTICS [KYNET_stat_Matters_On_Permissions_Code] ON [dbo].[Matters]([Permissions], [Code])

GO

IF EXISTS(select * 
            from sys.[objects] SO
                 INNER JOIN sys.[stats] SS
                         ON SS.[object_id] = SO.[object_id]
                        AND SS.[name] = 'KYNET_stat_Matters_On_Permissions_ClientCode_Code'
           where SO.[name] = 'matters'
             AND SO.[type] = 'U')
BEGIN
  drop statistics [dbo].[matters].[KYNET_stat_Matters_On_Permissions_ClientCode_Code]
END
GO

CREATE STATISTICS [KYNET_stat_Matters_On_Permissions_ClientCode_Code] ON [dbo].[Matters]([Permissions], [ClientCode], [Code])

GO

--MOVED to TableScripts as part of the changes to move "closed" case information back to main tables. START
--
--IF EXISTS
--  (SELECT *
--     FROM SYS.[indexes] SO
--    WHERE SO.[name] = 'KYNET_index_Matters_On_Code_Permissions_ClientCode')
--BEGIN
--  DROP INDEX [KYNET_index_Matters_On_Code_Permissions_ClientCode] ON [dbo].[Matters]
--END
--GO
--CREATE NONCLUSTERED INDEX [KYNET_index_Matters_On_Code_Permissions_ClientCode] ON [dbo].[Matters] 
--(
--	[Code] ASC,
--	[Permissions] ASC,
--	[ClientCode] ASC
--)
--INCLUDE ( [Description]) WITH (SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF) ON [PRIMARY]

--GO
--
--MOVED to TableScripts as part of the changes to move "closed" case information back to main tables. END

IF EXISTS(select * 
            from sys.[objects] SO
                 INNER JOIN sys.[stats] SS
                         ON SS.[object_id] = SO.[object_id]
                        AND SS.[name] = 'KYNET_stat_Matters_On_Code'
           where SO.[name] = 'matters'
             AND SO.[type] = 'U')
BEGIN
  drop statistics [dbo].[matters].[KYNET_stat_Matters_On_Code]
END
GO

CREATE STATISTICS [KYNET_stat_Matters_On_Code] ON [dbo].[Matters]([ClientCode], [Code])

GO

UPDATE SKL
   SET SKL.[COMMENT] = '003 Indexes_For_Query_Optimising.sql' 
  FROM [dbo].[KYScriptLog] SKL
 WHERE SKL.[MajorVersion] = 5
   AND SKL.[MinorVersion] = 1
   AND SKL.[Build] = 1
   AND SKL.[Revision] = 155
   AND SKL.[COMMENT] = '003 Indexes_For_Query_Optimising.sql **FAILED**'
GO

SET NOCOUNT OFF
SET NOEXEC OFF
GO